/*
  Uygulama Adı  : Hotmail e-posta gönderme uygulaması
  Açıklama      : NodeMCU V3 ESP8266 ESP-12E ile hotmail e-posta gönderme uygulaması
  Tarih         : 03 Eylül 2023
  Yazan         : İlhan DEMİR
*/

#include <Arduino.h>
#include <ESP8266WiFi.h>
#include <ESP_Mail_Client.h> //E-posta gönderme için gerekli kütüphaneyi ekle.

//ESP8266'nın bağlanacağı kablosuz ağ bilgilerini tanımla.
#define wifi_ssid "kablosuz_ağ_adı"
#define wifi_sifre "kablosuz_ağ_şifresi"

//Hotmail SMTP sunucu ve port numarası bilgilerini tanımla.
#define SMTP_Sunucu "smtp.office365.com"
#define SMTP_Port 587

//Oturum açma kimlik bilgileri (Gönderen e-posta bilgileri) tanımla.
//Hotmail hesabından 2 adımlı doğrulama açılmalı ve uygulamaya özel şifre oluşturulmalıdır.
#define gonderen_eposta_adres "gonderen@hotmail.com"
#define gonderen_eposta_sifre "uygulama_şifresi"

//E-posta mesajı başlık ve konu bilgilerini tanımla.
#define mesaj_baslik "NodeMCU ESP8266 ESP-12E"
#define mesaj_konu "ESP8266 ESP-12E Test E-postası"

//Alıcı e-posta adresi tanımla.
#define alici_eposta_adres "alici@gmail.com"

SMTPSession smtp;        //smtp isimli class (sınıf) tanımla.
ESP_Mail_Session oturum; //oturum isimli class (sınıf) tanımla.
SMTP_Message mesaj;      //mesaj isimli class (sınıf) tanımla.

void setup()
{
  Serial.begin(115200);                 //Seri haberleşme hızını 115200 baud ayarla.
  Serial.println();
  Serial.println("ESP8266 yapılandırılıyor...");
  WiFi.begin(wifi_ssid, wifi_sifre);    //Wifi SSID ve şifre bilgilerini tanımla.
  Serial.println();
  Serial.println ("Bağlantı kuruluyor.");

  while (WiFi.status() != WL_CONNECTED) //Wi-Fi bağlantısı kurulana kadar bekle.
  {
    //Bağlantı sağlanana kadar her 200 msn'de bir . (nokta) karakteri gönder.
    Serial.print(".");
    delay(200);
  }

  Serial.println();
  Serial.println ("Bağlantı kuruldu.");
  Serial.print ("Kablosuz ağ adı = ");
  Serial.println (wifi_ssid);
  Serial.print("IP Adresi = ");
  Serial.println(WiFi.localIP());
  Serial.println();
  smtp.debug(1);

  //SMTP sunucu oturum açma bilgileri
  oturum.server.host_name = SMTP_Sunucu ;
  oturum.server.port = SMTP_Port;
  oturum.login.email = gonderen_eposta_adres;
  oturum.login.password = gonderen_eposta_sifre;
  oturum.login.user_domain = "";

  //E-posta mesajı bilgileri
  mesaj.sender.name = mesaj_baslik;
  mesaj.sender.email = gonderen_eposta_adres;
  mesaj.subject = mesaj_konu;
  mesaj.addRecipient(alici_eposta_adres, alici_eposta_adres);

  //HTML mesajı gönder.
  String htmlMsg = "<div style=\"color:#0000FF;\"><h1>Merhaba</h1><p>Bu e-posta iletisi NodeMCU ESP8266 ESP-12E cihazından gönderilmiştir.</p></div>";
  mesaj.html.content = htmlMsg.c_str();
  mesaj.html.content = htmlMsg.c_str();
  mesaj.text.charSet = "us-ascii";
  mesaj.html.transfer_encoding = Content_Transfer_Encoding::enc_7bit;

  /*
    Basit kısa mesaj gönder.
    String textMsg = "Merhaba, bu e-posta iletisi NodeMCU ESP8266 ESP-12E cihazından gönderilmiştir.";
    mesaj.text.content = textMsg.c_str();
    mesaj.text.charSet = "us-ascii";
    mesaj.text.transfer_encoding = Content_Transfer_Encoding::enc_7bit;
  */

  if (!smtp.connect(&oturum)) //SMTP sunucu oturum açılmışsa mesaj gönderilir.
    return;

  if (!MailClient.sendMail(&smtp, &mesaj)) //Oturum açılmamışsa hata verir.
  {
    Serial.println();
    Serial.println("E-posta gönderilirken hata oluştu.");
    String hata = smtp.errorReason();
    Serial.println ("Hata: " + hata); //Hatanın ne olduğunu yazdır.
  }
}

void loop()
{}
