/*
  Uygulama Adı  : WEB tarayıcı üzerinden PWM uygulaması
  Açıklama      : NodeMCU V3 ESP8266 ESP-12E STA (station: istasyon)
                  çalışma modundayken web tarayıcı üzerinden LED parlaklığını
                  ayarlama (PWM) uygulaması
  Tarih         : 24 Ağustos 2023
  Yazan         : İlhan DEMİR
*/

#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>

//ESP8266'nın bağlanacağı kablosuz ağ bilgilerini tanımla.
const char *ssid = "kablosuz_ag_adiniz";
const char *sifre = "kablosuz_ag_sifreniz";

//sunucu isimli server tanımla. Web tarayıcılar için port numarası 80.
ESP8266WebServer sunucu(80);
//IP adresi, ağ geçidi ve alt ağ maskesi tanımla.
IPAddress yerelIP(192, 168, 1, 32);
IPAddress agGecidi(192, 168, 1, 1);
IPAddress altAgMaskesi(255, 255, 255, 0);
/*Windows cmd komut satırında ipconfig programını kullanarak
  ağ geçidi, alt ağ maskesi bilgilerini öğrenebilirsiniz.*/

#define led D7
String pwmDegeri = "0";

void setup()
{
  pinMode(led, OUTPUT);
  analogWrite(led, 0); //led (D7) pinine PWM 0 değerini gönder.

  Serial.begin(115200);      //Seri haberleşme hızını 115200 baud ayarla.
  Serial.println();
  Serial.print("İstasyon yapılandırılıyor...");

  WiFi.mode(WIFI_STA);       //ESP8266'yı STA (station: istasyon) çalışma moduna al.
  WiFi.config(yerelIP, agGecidi, altAgMaskesi); //IP, ağ geçidi ve alt ağ maskesi adreslerini belirle.
  WiFi.begin(ssid, sifre);   //Wifi SSID ve şifre bilgilerini tanımla.

  Serial.println();
  Serial.println ("Bağlantı kuruluyor.");
  while (WiFi.status() != WL_CONNECTED) //Wi-Fi bağlantısı kurulana kadar bekle.
  {
    //Bağlantı sağlanana kadar her 500 msn'de bir . (nokta) karakteri gönder.
    delay(500);
    Serial.print(".");
  }

  Serial.println();
  Serial.println ("Bağlantı kuruldu.");
  Serial.print ("Kablosuz ağ adı = ");
  Serial.println (ssid);
  Serial.print("IP Adresi = ");
  Serial.println(WiFi.localIP());

  sunucu.on("/", anasayfa);        //Web tarayıcıya IP adresi yazılırsa anasayfa() fonksiyonunu çalıştır.
  sunucu.on("/veri", pwmGonder);   // /veri linki geldiğinde pwmGonder() fonksiyonunu çalıştır.
  sunucu.onNotFound(sayfa_bulunamadi);//Bilinmeyen bir istek gelirse sayfa_bulunamadi() fonksiyonunu çalıştır.

  sunucu.begin();                  //Sunucuyu başlat.
  Serial.println();
  Serial.println("HTTP sunucu başlatıldı.");
}

void loop()
{
  sunucu.handleClient();           //İşlemlerin sürekli kontrolü için handleClient fonksiyonunu çalıştır.
}

void sayfa_bulunamadi()            //Hatalı bir istek yapılırsa bu fonksiyon çalışır.
{
  String sayfa = "<!doctype html>";//Html sayfası oluştur. String tipinde sayfa değişkenine yükle.
  sayfa += "<html>";               //HTML bilmiyorsanız çevrimiçi HTML düzenleyiciden yararlanabilirsiniz.
  sayfa += "<head>";
  sayfa += "<meta charset=UTF-8>";
  sayfa += "<title>WEB üzerinden PWM Uyg</title>";
  sayfa += "</head>";
  sayfa += "<body>";
  sayfa += "<h2>404 - Aradığınız sayfa bulunamadı.</h2>";
  sayfa += "<p><a href= \"/\"><strong>Ana Sayfa</strong></a></p>";
  sayfa += "</body>";
  sayfa += "</html>";

  sunucu.send(200, "text/html; charset=utf-8", sayfa); //Web sayfasını istek yapılan tarayıcıya gönder.
  //sunucu.send(404, "text/html; charset=utf-8", "<html><h1>404 - Aradığınız sayfa bulunamadı.</h1></html>"); //Ekrana hata mesajı yazdır.
}

void anasayfa()                    //IP adresi ile istek yapılırsa bu fonksiyon çalışır.
{
  String sayfa = "<!doctype html>";//Html sayfası oluştur. String tipinde sayfa değişkenine yükle.
  sayfa += "<html>";
  sayfa += "<head>";
  sayfa += "<meta charset=UTF-8>";
  sayfa += "<title>WEB üzerinden PWM Uyg</title>";
  sayfa += "</head>";
  sayfa += "<body>";
  sayfa += "<h2><span style=\"font-family: terminal, monaco, monospace;\"><span style=\"color: #3598db;\"><em><strong>www.beyzemiter.com</strong></em></span></h2>";
  sayfa += "<h3><span style=\"font-family: terminal, monaco, monospace;\"><span style=\"color: #3598db;\"><em>Bilginin efendisi olmak için çalışmanın kölesi olmak şarttır. Balzac</em></h3>";
  sayfa += "<p>&nbsp;</p>";

  sayfa += "<form action=\"/veri\">"; //veri isminde form action oluştur.
  //min değeri 0, max değeri 1023 olan pwm isminde argüman oluştur.
  sayfa += "<p><span style=\"font-family: verdana, geneva, sans-serif;\">PWM Ayarı (0-1023) <input type=\"range\" name=\"pwm\" min=\"0\" max=\"1023\"";
  sayfa += "value=\"" + pwmDegeri + "\">";
  //pwm değerini Gönder butonuyla pwmGonder sayfasına aktar.
  sayfa += "<input type=\"submit\" value=\"Gönder\"></span></p>";
  //Slider (kaydırıcı) değerini web tarayıcıda göster.
  sayfa += "<p><span style=\"font-family: verdana, geneva, sans-serif;\">PWM (Parlaklık) Değeri = " + pwmDegeri + "</span></p>";

  sayfa += "<h5><span style=\"font-family: terminal, monaco, monospace;\"><em><span style=\"color: #3598db;\">&copy; İlhan DEMİR</span></em></span></h5>";
  sayfa += "</body>";
  sayfa += "</html>";

  sunucu.send(200, "text/html; charset=utf-8", sayfa); //Web sayfasını istek yapılan tarayıcıya gönder.
}

void pwmGonder()                   //IP adresi /veri linkiyle istek yapılırsa bu fonksiyon çalışır.
{
  pwmDegeri = sunucu.arg("pwm");       //pwm isimli argümanın değerini String tipinde pwmDegeri değişkenine yükle.
  analogWrite(led, pwmDegeri.toInt()); //pwmDegeri değişkenini tam sayıya çevir, led(D7) pinine gönder.
  Serial.println("PWM Değeri = " + pwmDegeri); //pwmDegeri değişkenini seri port ekranında yazdır.

  String sayfa = "<!doctype html>";//Html sayfası oluştur. String tipinde sayfa değişkenine yükle.
  sayfa += "<html>";
  sayfa += "<head>";
  sayfa += "<meta charset=UTF-8>";
  sayfa += "<title>WEB üzerinden PWM Uyg</title>";
  sayfa += "</head>";
  sayfa += "<p>&nbsp;</p>";

  sayfa += "<form action=\"/veri\">"; //veri isminde form action oluştur.
  sayfa += "<p><span style=\"font-family: verdana, geneva, sans-serif;\">PWM Ayarı (0-1023) <input type=\"range\" name=\"pwm\" min=\"0\" max=\"1023\"";
  sayfa += "value=\"" + pwmDegeri + "\">"; //Sayfa yenilendiği için slider (kaydırıcı) değerini ayarlanan konuma getir.
  sayfa += "<input type=\"submit\" value=\"Gönder\"></span></p>";
  //Slider (kaydırıcı) değerini web tarayıcıda göster.
  sayfa += "<p><span style=\"font-family: verdana, geneva, sans-serif;\">PWM (Parlaklık) Değeri = " + pwmDegeri + "</span></p>";

  sayfa += "<p><a href= \"/\"><strong>Ana Sayfa</strong></a></p>";
  sayfa += "</body>";
  sayfa += "</html>";

  sunucu.send(200, "text/html; charset=utf-8", sayfa);        //Web sayfasını istek yapılan tarayıcıya gönder.
}
